<?php
// Tests how footnotes from included docs are put at the topmost doc's end.

class UtbePager extends UWikiPagerStub {
  function ReadPage($file, $format = null) { return $GLOBALS['titIncludes'][$file]; }
}

class Utbe_dynamic_Root extends Upre_Root {
  function IsDynamic($format, $params) { return true; }
}


  $GLOBALS['titIncludes'] = array('sub' => '
---------
f ((**)) ((**))
p
((** sub))
---
{{Include subsub}}
-------',
                                  'subsub' => '
f ((*)) ((*))
p
((* subsub))');

  $src = '
f ((*))
p
((* ext 1))

{{Include sub}}

f ((**))
p
((* ext 2))

p

****
';

$expectedHTML = '
<p class="default">
f <a href="#footnote_1" title="*" name="referred_footnote_1" class="round-brackets footnote internal">*</a>
p
<a name="p_0-5" href="#p_0-5" title="#p_0-5" class="anchor">¶</a>
</p>
<a name="sub" href="#sub" title="#sub" class="anchor include block-anchor">
¶
</a>
<hr class="thin" />
<p class="default">
f <a href="#footnote_3" title="**" name="referred_footnote_3" class="round-brackets footnote internal">*</a> <a href="#footnote_3" title="**" name="referred_footnote_3_1" class="round-brackets footnote internal">*</a>
p
<a name="p_0-3" href="#p_0-3" title="#p_0-3" class="anchor">¶</a>
</p>
<hr class="thin" />
<a name="subsub" href="#subsub" title="#subsub" class="anchor include block-anchor">
¶
</a>
<p class="default">
f <a href="#footnote_4" title="*" name="referred_footnote_4" class="round-brackets footnote internal">*</a> <span title="Referred footnote* is missing." class="round-brackets footnote internal missing-footnote">*</span>
p
<a name="p_0-1" href="#p_0-1" title="#p_0-1" class="anchor">¶</a>
</p>
<hr class="thin" />
<p class="default">
f <a href="#footnote_2" title="**" name="referred_footnote_2" class="round-brackets footnote internal">*</a>
p
<a name="p_0-7" href="#p_0-7" title="#p_0-7" class="anchor">¶</a>
</p>
<p class="default">
p
<a name="p_0-9" href="#p_0-9" title="#p_0-9" class="anchor">¶</a>
</p>
<hr class="dotted" />
<div id="footnote_1" class="block-footnote">
<ul class="origins"><li><a href="#referred_footnote_1">[^]</a></li></ul>
<p class="default">
 ext 1
<a name="p_0-6" href="#p_0-6" title="#p_0-6" class="anchor">¶</a>
</p>
</div>
<div id="footnote_3" class="block-footnote">
<ul class="origins"><li><a href="#referred_footnote_3">[^]</a></li><li><a href="#referred_footnote_3_1">[^]</a></li></ul>
<p class="default">
 sub
<a name="p_0-4" href="#p_0-4" title="#p_0-4" class="anchor">¶</a>
</p>
</div>
<div id="footnote_4" class="block-footnote">
<ul class="origins"><li><a href="#referred_footnote_4">[^]</a></li></ul>
<p class="default">
 subsub
<a name="p_0-2" href="#p_0-2" title="#p_0-2" class="anchor">¶</a>
</p>
</div>
<div id="footnote_2" class="block-footnote">
<ul class="origins"><li><a href="#referred_footnote_2">[^]</a></li></ul>
<p class="default">
 ext 2
<a name="p_0-8" href="#p_0-8" title="#p_0-8" class="anchor">¶</a>
</p>
</div>
';

  $doc = new UWikiDocument($src);
  $doc->settings = $settings;
  $doc->settings->pager = new UtbePager;
  $doc->settings->footnotesAtTheEnd = true;
  $doc->LoadMarkup('wacko');
  $doc->Parse();
  $html = $doc->ToHTML();

  TestEquality( preg_replace('/(\r?\n)+/u', "\n", trim($html)), trim($expectedHTML) );
